//+------------------------------------------------------------------+
//|                                Adaptive Moving Average ARROW.mq5 |
//|                        Copyright 2020, MetaQuotes Software Corp. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2020, MetaQuotes Software Corp."
#property link      "https://www.mql5.com"
#property version   "1.000"
#property indicator_chart_window
#property indicator_buffers 3
#property indicator_plots   1
//--- plot AMA
#property indicator_label1  "AMA"
#property indicator_type1   DRAW_COLOR_ARROW
#property indicator_color1  clrRed,clrBlue
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1
//--- input parameters
input group           "Adaptive Moving Average"
input int                  Inp_AMA_ama_period      = 15;          // AMA: average period for AMA
input int                  Inp_AMA_fast_ma_period  = 2;           // AMA: fast MA period
input int                  Inp_AMA_slow_ma_period  = 30;          // AMA: slow MA period
input int                  Inp_AMA_ama_shift       = 0;           // AMA: horizontal shift of the indicator
input ENUM_APPLIED_PRICE   Inp_AMA_applied_price   = PRICE_CLOSE; // AMA: type of the price
input group           "ARROW"
input uchar                InpArrowCode            = 117;         // Arrow: code (font Wingdings)
input int                  InpArrowShift           = 10;          // Arrow: vertical shift in pixel
//--- indicator buffers
double   AMABuffer[];
double   AMAColors[];
double   iAMABuffer[];
//---
int      handle_iAMA;                           // variable for storing the handle of the iAMA indicator
int      bars_calculated=0;                     // we will keep the number of values in the Adaptive Moving Average indicator
int      start_index=0;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,AMABuffer,INDICATOR_DATA);
   SetIndexBuffer(1,AMAColors,INDICATOR_COLOR_INDEX);
   SetIndexBuffer(2,iAMABuffer,INDICATOR_CALCULATIONS);
//--- setting a code from the Wingdings charset as the property of PLOT_ARROW
   PlotIndexSetInteger(0,PLOT_ARROW,InpArrowCode);
//--- set the vertical shift of arrows in pixels
   PlotIndexSetInteger(0,PLOT_ARROW_SHIFT,-InpArrowShift);
//--- an empty value for plotting, for which there is no drawing
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//--- create handle of the indicator iAMA
   handle_iAMA=iAMA(Symbol(),Period(),Inp_AMA_ama_period,Inp_AMA_fast_ma_period,
                    Inp_AMA_slow_ma_period,Inp_AMA_ama_shift,Inp_AMA_applied_price);
//--- if the handle is not created
   if(handle_iAMA==INVALID_HANDLE)
     {
      //--- tell about the failure and output the error code
      PrintFormat("Failed to create handle of the iAMA indicator for the symbol %s/%s, error code %d",
                  Symbol(),
                  EnumToString(Period()),
                  GetLastError());
      //--- the indicator is stopped early
      return(INIT_FAILED);
     }
//---
   start_index=Inp_AMA_ama_period+Inp_AMA_fast_ma_period+Inp_AMA_ama_shift;
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
   if(rates_total<start_index)
      return(0);
//--- number of values copied from the iAMA indicator
   int values_to_copy;
//--- determine the number of values calculated in the indicator
   int calculated=BarsCalculated(handle_iAMA);
   if(calculated<=0)
     {
      PrintFormat("BarsCalculated() returned %d, error code %d",calculated,GetLastError());
      return(0);
     }
//--- if it is the first start of calculation of the indicator or if the number of values in the iAMA indicator changed
//---or if it is necessary to calculated the indicator for two or more bars (it means something has changed in the price history)
   if(prev_calculated==0 || calculated!=bars_calculated || rates_total>prev_calculated+1)
     {
      //--- if the iAMABuffer array is greater than the number of values in the iAMA indicator for symbol/period, then we don't copy everything
      //--- otherwise, we copy less than the size of indicator buffers
      if(calculated>rates_total)
         values_to_copy=rates_total;
      else
         values_to_copy=calculated;
     }
   else
     {
      //--- it means that it's not the first time of the indicator calculation, and since the last call of OnCalculate()
      //--- for calculation not more than one bar is added
      values_to_copy=(rates_total-prev_calculated)+1;
     }
//--- fill the arrays with values of the Adaptive Moving Average indicator
//--- if FillArraysFromBuffer returns false, it means the information is nor ready yet, quit operation
   if(!FillArrayFromBuffer(iAMABuffer,Inp_AMA_ama_shift,handle_iAMA,values_to_copy))
      return(0);
//--- memorize the number of values in the Adaptive Moving Average indicator
   bars_calculated=calculated;
//--- main loop
   int limit=prev_calculated-1;
   if(prev_calculated==0)
     {
      limit=start_index;
      for(int i=0; i<limit; i++)
        {
         AMABuffer[i]=0.0;
         AMAColors[i]=0.0;
        }
     }
   for(int i=limit; i<rates_total; i++)
     {
      AMABuffer[i]=high[i];
      if(close[i]>iAMABuffer[i])
         AMAColors[i]=1.0;
      else
         AMAColors[i]=0.0;
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
//| Filling indicator buffer from the iAMA indicator                 |
//+------------------------------------------------------------------+
bool FillArrayFromBuffer(double &ama_buffer[],  // indicator buffer of the AMA line
                         int a_shift,           // shift of the AMA line
                         int ind_handle,        // handle of the iAMA indicator
                         int amount             // number of copied values
                        )
  {
//--- reset error code
   ResetLastError();
//--- fill a part of the iAMABuffer array with values from the indicator buffer that has 0 index
   if(CopyBuffer(ind_handle,0,-a_shift,amount,ama_buffer)<0)
     {
      //--- if the copying fails, tell the error code
      PrintFormat("Failed to copy data from the iAMA indicator, error code %d",GetLastError());
      //--- quit with zero result - it means that the indicator is considered as not calculated
      return(false);
     }
//--- everything is fine
   return(true);
  }
//+------------------------------------------------------------------+
//| Indicator deinitialization function                              |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
   if(handle_iAMA!=INVALID_HANDLE)
      IndicatorRelease(handle_iAMA);
  }
//+------------------------------------------------------------------+
